#!/usr/bin/python3

# (C) Christof Kaser

import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, GObject, GLib

import shutil
import _thread
import os
import sys
import urllib.request
import grp
import subprocess
import pwd

files = [
	"irdu.img", "krnl.z", "root.fs", "install.bat"
]

files_misc = [
	"install2usb.hta", "install2usb.py", "_copy.js", "syslinux.cfg",
	"syslxw.exe", "syslx.exe",
	"bootx64.efi", "ldlinux.e64"
]

def call(args):
	s = ''
	p=subprocess.Popen(args, stdout=subprocess.PIPE)
	for l in p.stdout:
		s = s + l
	return (p.wait(), s)

def prx(s):
	iter = out.get_end_iter()
	out.insert(iter, s + "\n")

def pr(s):
	#GObject.idle_add(prx, s)
	GLib.idle_add(prx, s)

def status(s):
	info.set_markup("<b><big>" + s + "</big></b>")

def copy(s, d):
	try:
		shutil.copy2(source + "/" + s, d)
#		os.chmod(d, 0700)
#		f = open(d)
#		os.fsync(f.fileno())
#		f.close()
	except IOError as e:
		pr("*** IOError " + e.strerror)
		raise

def mdir(d):
	if not os.path.exists(d): os.makedirs(d)


def copy_thread():
	try:
		global stop
		mdir(dest)
		mdir(dest + "../data")
		for fn in files:
			pr("Copy " + fn)
			copy(fn, dest)
			if stop: return

		mdir(dest + "misc")
		for fn in files_misc:
			pr("Copy " + fn)
			copy("misc/" + fn, dest + "misc")
			if stop: return

		for h in comps:
			if stop: return
			if h[0].get_active():
				pr("Copy " + h[1])
				copy(h[1], dest)
			if stop: return

		mdir(dest + "../efi")
		mdir(dest + "../efi/boot")
		copy("misc/bootx64.efi", dest + "../efi/boot/")
		copy(("misc/bootx64.efi", dest + "../efi/boot/")
		copy(("misc/ldlinux.e64", dest + "../efi/boot/")
		copy(("misc/syslinux.cfg", dest + "..")

		if biosboot.get_active():
			pr("For 'syslinux' you need adminstrator privileges")
			r = call(['pkexec', os.getcwd() + '/misc/syslx.exe', '-i', dest_dev])
			if r[0] != 0: pr("Error")
			pr(r[1])
			
		status("Installation completed")
		pr("* Completed *")

	except IOError as e:
		status("Installation failed")
		pr("Installation failed")

	spin.stop()

def get_dests():
	if not os.path.exists('/media/' + user): return
	a = os.listdir('/media/' + user)
	for i in a:
		p = '/media/' + user + '/' + i
		if not os.path.ismount(p): continue

		h = os.stat(p).st_dev
		dev = ''
		if h == 0x801 :
			dev = '/dev/sda1'
		elif h == 0x811 :  
			dev = '/dev/sdb1'
		elif h == 0x821 :  
			dev = '/dev/sdc1'
		elif h == 0x831 :  
			dev = '/dev/sdd1'
		elif h == 0x800 :  
			dev = '/dev/sda'
		elif h == 0x810 :  
			dev = '/dev/sdb'
		elif h == 0x820 :  
			dev = '/dev/sdc'
		elif h == 0x830 :  
			dev = '/dev/sdd'
#		elif h == 0xfe00 :  
#		elif h == 0x700 :  
#			dev = '/w/dosx.img'
		else: print("dev:", hex(h))

		if dev != '':
			combo.append_text(i)
			dests.append((i, dev))
	

def init():
	global dests, user, error    
	user = pwd.getpwuid(os.getuid())[0]

	dests = []
	get_dests()

	print(dests)

	if dests == []:
		status("No USB drive found")
		return

	btn.set_sensitive(True)
	combo.set_active(0)
	status("USB drive for installation: ")

def install(self, widget, data=None):
	global dest, dest_dev
	spin.start()
	h = combo.get_active()
	dest = '/media/' + user + '/' + dests[h][0] + "/kalinx/"
	dest_dev = dests[h][1]
	
	combo.hide()
	status("Install to " + dest)

	btn.set_sensitive(False)	
	for h in comps:
		h[0].set_sensitive(False)

	global stop
	stop = False
	_thread.start_new_thread(copy_thread, ())	

def delete_event(widget, event, data=None):
	global stop
	stop = True
	return False

def destroy(widget, data=None):
	Gtk.main_quit()

def main():
	global out, error, info, combo, btn, biosboot, spin, source
	global comps, biosboot, out

	error = False

	win = Gtk.Window()
	win.connect("delete_event", delete_event)
	win.connect("destroy", destroy)
	win.set_border_width(2)
	win.set_title("Kalinx Install to USB Drive")
	
	vbox = Gtk.VBox()
	win.add(vbox)

	hbox = Gtk.HBox()
	vbox.pack_start(hbox, False, False, 0)
	info = Gtk.Label()
#	info.set_alignment(0.0, 0.0)
	hbox.pack_start(info, False, False, 0)

	combo = Gtk.ComboBoxText()
	hbox.pack_start(combo, False, False, 10)

	hbox = Gtk.HBox()
	vbox.pack_start(hbox, False, False, 0)
	btn = Gtk.Button.new_with_label("Install")
	btn.set_sensitive(False)
	btn.connect("clicked", install, None)
	hbox.pack_start(btn, False, False, 0)

	spin = Gtk.Spinner()
	hbox.pack_start(spin, False, False, 10)
	
	source_uri = "file://./"
	if len(sys.argv) >= 2: source_uri = sys.argv[1]
	source = urllib.request.url2pathname(source_uri)[7:]
	
	vbox.pack_start(Gtk.HSeparator(), False, False, 0)
	
	sz = 0;
	for f in files :
		if not os.path.exists(source + "/" + f):
			status("'" + f + "' is missing")
			error = True
			break
		
		sz += os.stat(source + "/" + f).st_size		  

	s = "Base System" + " - " + str(int(sz / 1000000)) + " MB"
	check = Gtk.CheckButton.new_with_label(s)
	check.set_active(True)
	check.set_sensitive(False)
	vbox.pack_start(check, False, False, 0)

	comps = []
	h = os.listdir(source)
	h.sort()
	for f in h:
		if f[-4:] == ".fsf":
			
			sz = os.stat(source + "/" + f).st_size
			s = f;
			if f == "java.fsf": s += " : Java Runtime"
			s += " - " + str(sz / 1000000) + " MB"
			check = Gtk.CheckButton(s, False)
			comps.append([check, f])
			vbox.pack_start(check, False, False, 0)
		
	vbox.pack_start(Gtk.HSeparator(), False, False, 0)
	biosboot = Gtk.CheckButton.new_with_label("BIOS boot (for old computer before 2012)")
	vbox.pack_start(biosboot, False, False, 0)
	vbox.pack_start(Gtk.HSeparator(), False, False, 0)

	hbox = Gtk.HBox()
	vbox.add(hbox)
	sw = Gtk.ScrolledWindow()
	sw.set_border_width(2)

	tv = Gtk.TextView()
	tv.set_editable(False)
	
	out = tv.get_buffer()
	sw.add(tv)
	hbox.add(sw)
	
	win.set_size_request(500, 550)
	win.show_all()
	
	if not error: init()
	if error: btn.set_sensitive(False)
		
	Gtk.main()	

main()

